/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.aabb;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.utils.AABBUtils;
import mod.chiselsandbits.utils.DirectionUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AABBCompressor {
    private AABBCompressor() {
        throw new IllegalStateException("Can not instantiate an instance of: AABBCompressor. This is a utility class");
    }

    public static List<AABB> compressStates(IAreaAccessor accessor, final CollisionType sizeType) {
        final BuildingState state = new BuildingState();
        accessor.forEachWithPositionMutator(IPositionMutator.xyz(), new Consumer<IStateEntryInfo>(){

            @Override
            public void accept(IStateEntryInfo stateEntryInfo) {
                if (state.getRegionBuildingAxisValue() != stateEntryInfo.getStartPoint().m_7096_()) {
                    state.setCurrentBox(null, null);
                }
                state.setRegionBuildingAxisValue(stateEntryInfo.getStartPoint().m_7096_());
                if (state.getFaceBuildingAxisValue() != stateEntryInfo.getStartPoint().m_7098_()) {
                    state.setCurrentBox(null, null);
                }
                state.setFaceBuildingAxisValue(stateEntryInfo.getStartPoint().m_7098_());
                Optional<Vec3> previousCenterPoint = state.getLastCenter();
                Vec3 centerPoint = stateEntryInfo.getCenterPoint();
                state.onNextEntry(centerPoint);
                Optional<Boolean> stepDirection = previousCenterPoint.flatMap(d -> DirectionUtils.getDirectionVectorBetweenIfAligned(centerPoint, d));
                Optional<AABB> potentialEntryData = AABBCompressor.buildBoundingBox(stateEntryInfo, sizeType);
                if (potentialEntryData.isEmpty()) {
                    state.setCurrentBox(null, centerPoint);
                    return;
                }
                AABB entryData = potentialEntryData.get();
                if (state.getCurrentBox() != null && stepDirection.map(direction -> AABBUtils.areBoxesNeighbors(state.getCurrentBox(), entryData, direction)).filter(b -> b).isPresent()) {
                    state.expandCurrentBoxToInclude(entryData, centerPoint);
                    if (AABBCompressor.attemptMergeWithNeighbors(state, centerPoint, state.getCurrentBox())) {
                        return;
                    }
                    return;
                }
                if (AABBCompressor.attemptMergeWithNeighbors(state, centerPoint, entryData)) {
                    return;
                }
                state.setCurrentBox(potentialEntryData.get(), centerPoint);
            }
        });
        return Lists.newArrayList(state.getBoxes());
    }

    private static boolean attemptMergeWithNeighbors(BuildingState state, Vec3 centerPoint, AABB entryData) {
        for (Direction offsetDirection : Direction.values()) {
            AABB neighborBox;
            Vec3 neighborCenter = centerPoint.m_82549_(Vec3.m_82528_((Vec3i)offsetDirection.m_122436_()).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()));
            Optional<AABB> potentialNeighborBox = state.getBoxFor(neighborCenter);
            if (!potentialNeighborBox.isPresent() || !AABBUtils.areBoxesNeighbors(entryData, neighborBox = potentialNeighborBox.get(), offsetDirection)) continue;
            state.expandBoxAt(neighborCenter, entryData, centerPoint);
            return true;
        }
        return false;
    }

    public static Optional<AABB> buildBoundingBox(IStateEntryInfo stateEntryInfo, CollisionType sizeType) {
        if (!sizeType.isValidFor(stateEntryInfo)) {
            return Optional.empty();
        }
        return Optional.of(stateEntryInfo.getBoundingBox());
    }

    private static final class BuildingState {
        private double regionBuildingAxis = Double.NEGATIVE_INFINITY;
        private double faceBuildingAxis = Double.NEGATIVE_INFINITY;
        private Vec3 lastCenterPoint = null;
        private AABB currentBox;
        private final Map<Vec3, AABB> boxAssignments = Maps.newHashMap();
        private final Multimap<AABB, Vec3> stateAssignments = HashMultimap.create();

        private BuildingState() {
        }

        public double getRegionBuildingAxisValue() {
            return this.regionBuildingAxis;
        }

        public void setRegionBuildingAxisValue(double regionBuildingAxis) {
            this.regionBuildingAxis = regionBuildingAxis;
        }

        public double getFaceBuildingAxisValue() {
            return this.faceBuildingAxis;
        }

        public void setFaceBuildingAxisValue(double faceBuildingAxis) {
            this.faceBuildingAxis = faceBuildingAxis;
        }

        public AABB getCurrentBox() {
            return this.currentBox;
        }

        public void setCurrentBox(AABB currentBox, Vec3 centerPoint) {
            this.currentBox = currentBox;
            if (currentBox != null) {
                this.boxAssignments.put(centerPoint, currentBox);
                this.stateAssignments.put((Object)currentBox, (Object)centerPoint);
            }
        }

        public Optional<AABB> getBoxFor(Vec3 target) {
            return Optional.ofNullable(this.boxAssignments.get(target));
        }

        public Optional<Vec3> getLastCenter() {
            return Optional.ofNullable(this.lastCenterPoint);
        }

        public void onNextEntry(Vec3 lastCenterPoint) {
            this.lastCenterPoint = lastCenterPoint;
        }

        public void expandCurrentBoxToInclude(AABB entryData, Vec3 centerPoint) {
            AABB current = this.getCurrentBox();
            if (current == null) {
                throw new IllegalStateException("Can not expand current box, if current is not set.");
            }
            AABB expanded = current.m_82367_(entryData);
            Collection currentlyAssignedToCurrent = this.stateAssignments.removeAll((Object)current);
            currentlyAssignedToCurrent.forEach(v -> this.boxAssignments.put((Vec3)v, expanded));
            this.stateAssignments.putAll((Object)expanded, (Iterable)currentlyAssignedToCurrent);
            this.boxAssignments.put(centerPoint, expanded);
            this.stateAssignments.put((Object)expanded, (Object)centerPoint);
            this.currentBox = expanded;
        }

        public Collection<AABB> getBoxes() {
            return this.stateAssignments.keySet();
        }

        public void expandBoxAt(Vec3 neighborCenter, AABB entryData, Vec3 centerPoint) {
            AABB current = this.boxAssignments.get(neighborCenter);
            if (current == null) {
                throw new IllegalStateException(String.format("Can not expand box at: %s, if current is not set.", neighborCenter));
            }
            AABB expanded = current.m_82367_(entryData);
            Collection currentlyAssignedToCurrent = this.stateAssignments.removeAll((Object)current);
            currentlyAssignedToCurrent.forEach(v -> this.boxAssignments.put((Vec3)v, expanded));
            this.stateAssignments.putAll((Object)expanded, (Iterable)currentlyAssignedToCurrent);
            this.boxAssignments.put(centerPoint, expanded);
            this.stateAssignments.put((Object)expanded, (Object)centerPoint);
        }
    }
}

